<?php
error_reporting(E_ALL);
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);

// 🌐 Obter a URL base dinamicamente
$protocol = isset($_SERVER['HTTPS']) && $_SERVER['HTTPS'] === 'on' ? "https" : "http";
$host = $_SERVER['HTTP_HOST'];
$basePath = dirname($_SERVER['SCRIPT_NAME']);
$baseUrl = "$protocol://$host$basePath";

// 🖼️🔼 Processar upload de logo se o formulário foi enviado
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_FILES['logo'])) {
    $jsonFile = __DIR__ . '/img/api.json';
    
    // 📥 Carregar configurações existentes ou criar novo
    $jsonData = file_exists($jsonFile) ? json_decode(file_get_contents($jsonFile), true) : [
        'logo' => $baseUrl . '/img/default-logo.png'
    ];

    $uploadDir = __DIR__ . '/img/';
    $response = ['success' => false, 'message' => '', 'newLogoUrl' => ''];

    try {
        // 🔄 Função para gerar nome aleatório de imagem
        function generateRandomImageName() {
            $chars = 'abcdefghijklmnopqrstuvwxyz0123456789';
            $result = '';
            for ($i = 0; $i < 8; $i++) {
                $result .= $chars[rand(0, strlen($chars) - 1)];
            }
            return $result . '.jpg';
        }

        // 🏢 Processar logo
        if (!empty($_FILES['logo']['name'])) {
            // 🔍 Verificar se é uma imagem
            $check = getimagesize($_FILES['logo']['tmp_name']);
            if($check === false) {
                throw new Exception('❌🖼️ O arquivo não é uma imagem válida');
            }

            // 📏 Verificar tamanho do arquivo (máx 2MB)
            if ($_FILES['logo']['size'] > 2 * 1024 * 1024) {
                throw new Exception('❌📏 Arquivo muito grande! Tamanho máximo: 2MB');
            }

            $logoName = 'logo-' . generateRandomImageName();
            $logoPath = $uploadDir . $logoName;
            
            if (move_uploaded_file($_FILES['logo']['tmp_name'], $logoPath)) {
                $newLogoUrl = $baseUrl . '/img/' . $logoName;
                $jsonData['logo'] = $newLogoUrl;
                $response['newLogoUrl'] = $newLogoUrl;
            } else {
                throw new Exception('❌🔼 Falha ao fazer upload do logo');
            }
        }
        
        // 💾 Salvar o JSON atualizado
        if (file_put_contents($jsonFile, json_encode($jsonData, JSON_PRETTY_PRINT | JSON_UNESCAPED_SLASHES))) {
            $response['success'] = true;
            $response['message'] = '✅🎉 Logo atualizado com sucesso!';
        } else {
            throw new Exception('❌💾 Falha ao salvar o arquivo JSON');
        }
    } catch (Exception $e) {
        $response['message'] = $e->getMessage();
    }

    // 📡 Retornar JSON para requisições AJAX
    header('Content-Type: application/json');
    echo json_encode($response);
    exit;
}

// 📋 Ler configurações atuais do logo
$jsonFile = __DIR__ . '/img/api.json';
$currentLogo = file_exists($jsonFile) ? json_decode(file_get_contents($jsonFile), true)['logo'] : $baseUrl . '/img/default-logo.png';

$page_title = "🖼️✨ Gerenciador de Logo";
$page_content = '
<div class="container mt-5">
    <div class="card shadow-sm">
        <div class="card-header bg-primary text-white">
            <h3 class="mb-0">🖼️✨ Upload de Logo</h3>
        </div>
        <div class="card-body">
            <form id="logoUploadForm" enctype="multipart/form-data" method="POST">
                <div class="mb-4">
                    <label for="logoUpload" class="form-label">📂 Selecione o novo logo:</label>
                    <input type="file" class="form-control" name="logo" id="logoUpload" accept="image/*" required>
                    <div class="form-text">📌 Formatos suportados: JPG, PNG. Tamanho recomendado: 300x100px</div>
                </div>
                
                <div class="mb-4">
                    <label class="form-label">👁️ Pré-visualização:</label>
                    <div id="logoPreviewContainer" class="border p-3 text-center">
                        <img id="logoPreview" src="' . $currentLogo . '" class="img-fluid" style="max-height: 150px;">
                        <div id="noLogoText" class="text-muted"' . (!empty($currentLogo) ? ' style="display:none;"' : '') . '>🖼️ Nenhum logo selecionado</div>
                    </div>
                </div>
                
                <button type="submit" class="btn btn-primary">
                    <i class="fas fa-upload me-2"></i>🔼 Enviar Logo
                </button>
                <div id="uploadStatus" class="mt-3"></div>
            </form>
            
            <div class="mt-5">
                <h5>ℹ️ Informações do Sistema:</h5>
                <div class="alert alert-info">
                    <p><strong>🌐 Domínio detectado:</strong> ' . $host . '</p>
                    <p><strong>📂 Subpasta detectada:</strong> ' . $basePath . '</p>
                    <p><strong>🔗 URL completa:</strong> ' . $baseUrl . '</p>
                </div>
            </div>
        </div>
    </div>
</div>

<style>
#logoPreviewContainer {
    background-image: linear-gradient(45deg, #eee 25%, transparent 25%), 
                     linear-gradient(-45deg, #eee 25%, transparent 25%), 
                     linear-gradient(45deg, transparent 75%, #eee 75%), 
                     linear-gradient(-45deg, transparent 75%, #eee 75%);
    background-size: 20px 20px;
    background-position: 0 0, 0 10px, 10px -10px, -10px 0px;
    min-height: 150px;
}
</style>

<script>
// 👁️ Preview da imagem antes do upload
document.getElementById("logoUpload").addEventListener("change", function(e) {
    const file = e.target.files[0];
    const preview = document.getElementById("logoPreview");
    const noLogoText = document.getElementById("noLogoText");
    
    if (file) {
        const reader = new FileReader();
        
        reader.onload = function(e) {
            preview.src = e.target.result;
            preview.style.display = "block";
            noLogoText.style.display = "none";
        }
        
        reader.readAsDataURL(file);
    } else {
        preview.src = "";
        preview.style.display = "none";
        noLogoText.style.display = "block";
    }
});

// 🚀 Envio do formulário via AJAX
document.getElementById("logoUploadForm").addEventListener("submit", function(e) {
    e.preventDefault();
    
    const formData = new FormData(this);
    const statusElement = document.getElementById("uploadStatus");
    const submitBtn = this.querySelector("button[type=\'submit\']");
    const preview = document.getElementById("logoPreview");
    
    // ⏳ Mostrar loading no botão
    submitBtn.disabled = true;
    submitBtn.innerHTML = \'<i class="fas fa-spinner fa-spin me-2"></i>⏳ Enviando...\';
    
    fetch("", {
        method: "POST",
        body: formData,
        headers: {
            "X-Requested-With": "XMLHttpRequest"
        }
    })
    .then(response => {
        if (!response.ok) throw new Error("🌐 Erro na rede");
        return response.json();
    })
    .then(data => {
        if (data.success) {
            statusElement.innerHTML = `
                <div class="alert alert-success d-flex align-items-center">
                    <i class="fas fa-check-circle me-2"></i>
                    <div>${data.message}</div>
                </div>
            `;
            
            // Atualizar preview com a nova imagem
            if (data.newLogoUrl) {
                preview.src = data.newLogoUrl;
            }
            
            // Mostrar confetes por 3 segundos
            if (typeof confetti === \'function\') {
                confetti({
                    particleCount: 150,
                    spread: 70,
                    origin: { y: 0.6 }
                });
                setTimeout(() => confetti.reset(), 3000);
            }
        } else {
            statusElement.innerHTML = `
                <div class="alert alert-danger d-flex align-items-center">
                    <i class="fas fa-exclamation-circle me-2"></i>
                    <div>❌ ${data.message}</div>
                </div>
            `;
        }
    })
    .catch(error => {
        statusElement.innerHTML = `
            <div class="alert alert-danger d-flex align-items-center">
                <i class="fas fa-exclamation-circle me-2"></i>
                <div>❌ Erro: ${error.message}</div>
            </div>
        `;
    })
    .finally(() => {
        submitBtn.disabled = false;
        submitBtn.innerHTML = \'<i class="fas fa-upload me-2"></i>🔼 Enviar Logo\';
    });
});
</script>

<!-- Biblioteca de confetes para efeito visual -->
<script src="https://cdn.jsdelivr.net/npm/canvas-confetti@1.5.1/dist/confetti.browser.min.js"></script>
';

include 'includes/layout.php';
?>