/*
 * Decompiled with CFR 0.152.
 */
package hu.uw.pallergabor.dedexer;

import hu.uw.pallergabor.dedexer.DexOptimizationData;
import hu.uw.pallergabor.dedexer.DexParser;
import hu.uw.pallergabor.dedexer.DexSignatureBlock;
import java.io.IOException;

public class DexPointerBlock
extends DexParser {
    private DexSignatureBlock dexSignatureBlock;
    private long fileSize;
    private long headerSize;
    private long linkSize;
    private long linkOffset;
    private long mapOffset;
    private long stringIdsSize;
    private long stringIdsOffset;
    private long typeIdsSize;
    private long typeIdsOffset;
    private long protoIdsSize;
    private long protoIdsOffset;
    private long fieldIdsSize;
    private long fieldIdsOffset;
    private long methodIdsSize;
    private long methodIdsOffset;
    private long classDefsSize;
    private long classDefsOffset;
    private long dataSize;
    private long dataOffset;

    @Override
    public void parse() throws IOException {
        DexOptimizationData dexOptimizationData = this.dexSignatureBlock.getDexOptimizationData();
        this.setDexOptimizationData(dexOptimizationData);
        if (dexOptimizationData != null && dexOptimizationData.isOptimized()) {
            this.setFilePosition(72L);
        }
        this.fileSize = this.read32Bit();
        this.dump("file size: 0x" + this.dumpLong(this.fileSize));
        this.headerSize = this.read32Bit();
        this.dump("header size: 0x" + this.dumpLong(this.headerSize));
        this.parseExpected32Bit(305419896L);
        this.linkSize = this.read32Bit();
        this.dump("link size: 0x" + this.dumpLong(this.linkSize));
        this.linkOffset = this.readFileOffset();
        this.dump("link offset: 0x" + this.dumpLong(this.linkOffset));
        this.mapOffset = this.readFileOffset();
        this.dump("map offset: 0x" + this.dumpLong(this.mapOffset));
        this.stringIdsSize = this.read32Bit();
        this.dump("string ids size: 0x" + this.dumpLong(this.stringIdsSize));
        this.stringIdsOffset = this.readFileOffset();
        this.dump("string ids offset: 0x" + this.dumpLong(this.stringIdsOffset));
        this.typeIdsSize = this.read32Bit();
        this.dump("type ids size: 0x" + this.dumpLong(this.typeIdsSize));
        this.typeIdsOffset = this.readFileOffset();
        this.dump("type ids offset: 0x" + this.dumpLong(this.typeIdsOffset));
        this.protoIdsSize = this.read32Bit();
        this.dump("proto ids size: 0x" + this.dumpLong(this.protoIdsSize));
        this.protoIdsOffset = this.readFileOffset();
        this.dump("proto ids offset: 0x" + this.dumpLong(this.protoIdsOffset));
        this.fieldIdsSize = this.read32Bit();
        this.dump("field ids size: 0x" + this.dumpLong(this.fieldIdsSize));
        this.fieldIdsOffset = this.readFileOffset();
        this.dump("field ids offset: 0x" + this.dumpLong(this.fieldIdsOffset));
        this.methodIdsSize = this.read32Bit();
        this.dump("method ids size: 0x" + this.dumpLong(this.methodIdsSize));
        this.methodIdsOffset = this.readFileOffset();
        this.dump("method ids offset: 0x" + this.dumpLong(this.methodIdsOffset));
        this.classDefsSize = this.read32Bit();
        this.dump("class defs size: 0x" + this.dumpLong(this.classDefsSize));
        this.classDefsOffset = this.readFileOffset();
        this.dump("class defs offset: 0x" + this.dumpLong(this.classDefsOffset));
        this.dataSize = this.read32Bit();
        this.dump("data size: 0x" + this.dumpLong(this.dataSize));
        this.dataOffset = this.readFileOffset();
        this.dump("data offset: 0x" + this.dumpLong(this.dataOffset));
    }

    public long getFileSize() {
        return this.fileSize;
    }

    public long getHeaderSize() {
        return this.headerSize;
    }

    public long getLinkSize() {
        return this.linkSize;
    }

    public long getLinkOffset() {
        return this.linkOffset;
    }

    public long getMapOffset() {
        return this.mapOffset;
    }

    public long getStringIdsSize() {
        return this.stringIdsSize;
    }

    public long getStringIdsOffset() {
        return this.stringIdsOffset;
    }

    public long getTypeIdsSize() {
        return this.typeIdsSize;
    }

    public long getTypeIdsOffset() {
        return this.typeIdsOffset;
    }

    public long getProtoIdsSize() {
        return this.protoIdsSize;
    }

    public long getProtoIdsOffset() {
        return this.protoIdsOffset;
    }

    public long getFieldIdsSize() {
        return this.fieldIdsSize;
    }

    public long getFieldIdsOffset() {
        return this.fieldIdsOffset;
    }

    public long getMethodIdsSize() {
        return this.methodIdsSize;
    }

    public long getMethodIdsOffset() {
        return this.methodIdsOffset;
    }

    public long getClassDefsSize() {
        return this.classDefsSize;
    }

    public long getClassDefsOffset() {
        return this.classDefsOffset;
    }

    public long getDataSize() {
        return this.dataSize;
    }

    public long getDataOffset() {
        return this.dataOffset;
    }

    public void setDexSignatureBlock(DexSignatureBlock dexSignatureBlock) {
        this.dexSignatureBlock = dexSignatureBlock;
    }
}

