/*
 * Decompiled with CFR 0.152.
 */
package hu.uw.pallergabor.dedexer;

import hu.uw.pallergabor.dedexer.DexInstructionParser;
import java.io.IOException;

public abstract class DedexerTask {
    public static final int MIN_PRIORITY = 0;
    protected DexInstructionParser instrParser;
    protected long offset;
    protected long base;

    public DedexerTask(DexInstructionParser instrParser, long base, long offset) {
        this.instrParser = instrParser;
        this.base = base;
        this.offset = offset;
    }

    public long getBase() {
        return this.base;
    }

    public long getOffset() {
        return this.offset;
    }

    public boolean equals(String str) {
        return this.toString().equals(str);
    }

    public boolean equals(DedexerTask otherTask) {
        if (otherTask == null) {
            return false;
        }
        long otherOffset = otherTask.getOffset();
        long otherBase = otherTask.getBase();
        if (this.offset == 0L && this.base == 0L || otherOffset == 0L && otherBase == 0L) {
            return this.toString().equals(otherTask.toString());
        }
        return this.offset == otherOffset && this.base == otherBase;
    }

    public abstract void doTask(boolean var1) throws IOException;

    public abstract void renderTask(long var1) throws IOException;

    public String toString() {
        return String.valueOf(this.getClass().getName()) + "; base: 0x" + Long.toHexString(this.base) + "; offset: 0x" + Long.toHexString(this.offset);
    }

    public int getPriority() {
        return 0;
    }

    public boolean getParseFlag(long position) {
        return false;
    }
}

